import { StarXpandCommand } from "star-io10-web";

export class LabelSample02_For203dpi_JapaneseFoodLabelCake_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(48.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            // モデルにより対応する文字エンコーディング指定APIが異なります。
            // 下記ページのSupported Modelを参照し、ご利用のモデルが対応するAPIを使用してください。
            // https://www.star-m.jp/products/s_print/sdk/star-io10-web/manual/ja/api-reference/star-xpand-command/printer-builder/style-cjk-character-priority.html
            .styleCjkCharacterPriority([
              StarXpandCommand.Printer.CjkCharacterType.Japanese,
            ])
            // https://www.star-m.jp/products/s_print/sdk/star-io10-web/manual/ja/api-reference/star-xpand-command/printer-builder/style-second-priority-character-encoding.html
            //.styleSecondPriorityCharacterEncoding(CharacterEncodingType.Japanese)

            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(48.0, 56.0),
              new StarXpandCommand.PageModeBuilder()
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    0.0,
                    3.5,
                    40.0,
                    52.0,
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.PageModeRuledLineParameter(
                    0.0,
                    7.5,
                    40.0,
                    7.5,
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.PageModeRuledLineParameter(
                    0.0,
                    23.5,
                    40.0,
                    23.5,
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.PageModeRuledLineParameter(
                    0.0,
                    27.5,
                    40.0,
                    27.5,
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.PageModeRuledLineParameter(
                    0.0,
                    31.5,
                    40.0,
                    31.5,
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.PageModeRuledLineParameter(
                    0.0,
                    43.5,
                    40.0,
                    43.5,
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.PageModeRuledLineParameter(
                    12.5,
                    3.5,
                    12.5,
                    55.5,
                  ),
                )
                .styleHorizontalPositionTo(0.5)
                .styleVerticalPositionTo(0.0)
                .actionPrintText("品　名")
                .styleHorizontalPositionTo(17.0)
                .actionPrintText("${name}\n")
                .styleHorizontalPositionTo(0.5)
                .actionPrintText("名　称")
                .styleHorizontalPositionTo(22.0)
                .actionPrintText("${classification}\n")
                .styleHorizontalPositionTo(0.5)
                .actionPrintText("原材料名")
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(26.0, 16.0)
                    .setX(13.0)
                    .setY(8.0),
                  new StarXpandCommand.PageModeBuilder().actionPrintText(
                    "${ingredients}\n",
                  ),
                )
                .styleHorizontalPositionTo(0.5)
                .styleVerticalPositionTo(24.0)
                .actionPrintText("内容量")
                .styleHorizontalPositionTo(23.0)
                .actionPrintText("${contents}\n")
                .styleHorizontalPositionTo(0.5)
                .actionPrintText("消費期限")
                .styleHorizontalPositionTo(13.0)
                .actionPrintText("${expiry_date}\n")
                .styleHorizontalPositionTo(0.5)
                .actionPrintText("保存方法")
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(26.0, 12.0)
                    .setX(13.0)
                    .setY(32.0),
                  new StarXpandCommand.PageModeBuilder().actionPrintText(
                    "${preservation_method}",
                  ),
                )
                .styleHorizontalPositionTo(0.5)
                .styleVerticalPositionTo(44.0)
                .actionPrintText("製造者")
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(26.0, 12.0)
                    .setX(13.0)
                    .setY(44.0),
                  new StarXpandCommand.PageModeBuilder().actionPrintText(
                    "${manufacturer}",
                  ),
                )
                .actionPrintImage(
                  new StarXpandCommand.Printer.PageModeImageParameter(
                    "japanese_food_label_cake_plastic.png",
                    41.0,
                    0.0,
                    48,
                  ),
                )
                .stylePrintDirection(
                  StarXpandCommand.Printer.PageModePrintDirection.BottomToTop,
                )
                .styleHorizontalPositionTo(6.0)
                .styleVerticalPositionTo(42.0)
                .actionPrintBarcode(
                  new StarXpandCommand.Printer.BarcodeParameter(
                    "${sku}",
                    StarXpandCommand.Printer.BarcodeSymbology.Jan13,
                  )
                    .setBarDots(3)
                    .setHeight(3.0)
                    .setPrintHri(true),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );

    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "name" : "ロールケーキ",
    "classification" : "洋菓子",
    "ingredients" : "卵、砂糖、小麦粉、ショートニング、油脂、ベーキングパウダー",
    "contents" : "1個",
    "expiry_date" : "2010年01月31日",
    "preservation_method" : "直射日光・高温多湿を避けて、保存してください。",
    "manufacturer" : "スターショップ\\nXXX県XXX市XXX町123-1\\nTEL 1234-567-890",
    "sku" : "0123456789012"
}`,
    );
  }
}
